//////////////////////////////////////////////////////
//	File	:	"CWinGameState.h"
//
//	Author	:	Liam Russell
//
//	Purpose	:	This is the win game state for the game
//////////////////////////////////////////////////////

#include "IGameState.h"

#include <windows.h>

// Forward declarations
class CSGD_Direct3D;
class CSGD_MessageSystem;
class CSGD_EventSystem;
class CSGD_TextureManager;
class CSGD_FModManager;
class CBaseMessage;
class CEvent;
class CSGD_DirectInput;
class CBitmapFontManager;
#include "CBitmapFont.h"

class CWinGameState : public IGameState
{
private:

	int				m_nImageID;					//	The image ID for the intro state.
	RECT			m_rImageArea;				//	The area of the image top draw for the background.
	CSGD_TextureManager* m_pTM;
	CSGD_DirectInput*	 m_pDI;
	CBitmapFontManager* m_pBM;
	CBitmapFont		m_pFont;

		
	//////////////////////////////////////////
	// Function: "CWinGameState"
	//
	// Purpose:  Constructor
	//////////////////////////////////////////
	CWinGameState();
	//////////////////////////////////////////
	// Function: "CWinGameState"
	//
	// Purpose:  Copy constructor
	//////////////////////////////////////////
	CWinGameState(const CWinGameState&);
	//////////////////////////////////////////
	// Function: "~CWinGameState"
	//
	// Purpose:  Destructor
	//////////////////////////////////////////
	~CWinGameState();
	//////////////////////////////////////////
	// Function: "operator="
	//
	// Purpose:  Overloaded assignment operator
	//////////////////////////////////////////
	CWinGameState& operator=(const CWinGameState&);

public:

	///////////////////////////////
	// Function: "CWinGameState"
	//
	// Purpose: Gets the Current instance of the 
	//			CAnimationPlayer singleton.	
	////////////////////////////////
	static CWinGameState* GetInstance()
	{
		static CWinGameState	instance;
		return &instance;
	}

	//////////////////////////////////////////
	// Function: "Enter"
	//
	// Purpose:  Initializes the class
	//////////////////////////////////////////
	void Enter(void);
	//////////////////////////////////////////
	// Function: "Exit"
	//
	// Purpose:  Cleans up the class 
	//////////////////////////////////////////
	void Exit(void);

	//////////////////////////////////////////
	// Function: "Input"
	// Purpose:  Handles input for the options
	//			 based on time
	//////////////////////////////////////////
	bool Input(float fElapsedTime);
	//////////////////////////////////////////
	// Function: "Update"
	//
	// Purpose:  Updates the class based on time
	//////////////////////////////////////////
	void Update(float fElapsedTime);
	//////////////////////////////////////////
	// Function: "Render"
	//
	// Purpose:  Draws the animations for the state
	//////////////////////////////////////////
	void Render(void);

};